unit Cambmain;
{ Screensaver Project: Cambrium
   Copyright 1997,1998, Oberon Medialab

  *** Use version 2.3b of the Oberon Animation Toolkit ***

  TODO:
  -
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, IniFiles, ExtCtrls, StdCtrls, uCreature, uLogoCanvas, uInfo,
  uSettings, uDuck, CheckLst;

const
   kScrollStep = 10;

   kMaxFrameRate = 11;

type
    TView = record
        dX,dY,dZ : Single;
        Size : Single;
        Phi : Single;
    end;

  TfrmCambrium = class(TForm)
    timerReloadValues: TTimer;
    gbSettings: TGroupBox;
    chklAnimals: TCheckListBox;
    butGo: TButton;
    Label1: TLabel;
    procedure sbStageMouseMove(Sender: TObject; Shift: TShiftState; X,    Y: Integer);
    procedure sbStageMouseUp(Sender: TObject; Button: TMouseButton;       Shift: TShiftState; X, Y: Integer);
    procedure sbStageMouseDown(Sender: TObject; Button: TMouseButton;     Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;                  Shift: TShiftState);
    procedure sbStageDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;      Shift: TShiftState; X, Y: Integer);
    procedure timerReloadValuesTimer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure butGoClick(Sender: TObject);
    procedure FormShow(Sender: TObject);


  private
    FCreatures : TCreatureList;
    FCaptured : TCreature;
    FView : TView;
    FLastBlitTime, FLastTick : LongInt;
    FStartTick : Integer;
    FExitAfter : Integer;
    FFPS : Real;
    FTicks : Integer;
    FbQuit, FPaused : Boolean;
    FbmOffscreen : TBitmap;
    function GetCreatures(Idx:Integer) : TCreature;
    procedure World2Screen( WX,WY,WPhi : Single;
                            var SX,SY,SPhi : Single );
    procedure Screen2World( SX,SY,SPhi : Single;
                            var WX,WY,WPhi : Single );
    procedure WMUser( var Msg : TMessage ); message WM_USER;

  public
    destructor Destroy; override;
    procedure RunSimulation;
    procedure UpdateScreen;
    procedure SaveAnimals;
    property Creatures[ Idx : Integer ] : TCreature read GetCreatures;
    property View : TView read FView write FView;
  end;

var
  frmCambrium: TfrmCambrium;

implementation

{$R *.DFM}


procedure TfrmCambrium.FormCreate(Sender: TObject);
begin
    FStartTick := GetTickCount;
    if ParamStr(1)<>'' then
        FExitAfter := StrToInt(ParamStr(1)) * 1000;

    FCaptured := nil;
    FLastTick := GetTickCount;
    FCreatures := TCreatureList.Create;
    FbmOffscreen := TBitmap.Create;
    FTicks := 0;
    // FbmOffscreen.Assign( sbStage.Picture );
    with FView do begin
        dX := 0;
        dY := 0;
        dZ := 0;
        Phi := 0;
        Size := 0.2;
    end;
end;

destructor TfrmCambrium.Destroy;
begin
    FbmOffscreen.Free;
    inherited Destroy;
end;

function TfrmCambrium.GetCreatures(Idx:Integer) : TCreature;
begin
    Result := FCreatures.Items[Idx];
end;

procedure TfrmCambrium.World2Screen( WX,WY,WPhi : Single;
                                        var SX,SY,SPhi : Single );
var
    X,Y : Single;
begin
    X := WX +FView.dX;
    Y := WY +FView.dY;
    SPhi := WPhi+FView.Phi;
    SX := (Width  div 2) + FView.Size*(Cos(FView.Phi) * X  - Sin(FView.Phi) * Y);
    SY := (Height div 2) + FView.Size*(Cos(FView.Phi) * Y  + Sin(FView.Phi) * X);
end;

procedure TfrmCambrium.Screen2World( SX,SY,SPhi : Single;
                                        var WX,WY,WPhi : Single );
var
    X,Y : Single;
begin
    WPhi := SPhi - FView.Phi;
    X := (SX - Width div 2)/FView.Size;
    Y := (SY - Height div 2)/FView.Size;
    WX := X - FView.dX;
    WY := Y - FView.dY;
end;



procedure TfrmCambrium.sbStageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
    SX,SY,SPhi, WX,WY,WPhi : Single;
begin
    if FCaptured<>nil then begin
        SPhi := 0;
        SX := X;
        SY := Y;
        Screen2World( SX,SY, SPhi, WX,WY,WPhi );
        FCaptured.XPos := WX;
        FCaptured.YPos := WY;
    end;
end;

procedure TfrmCambrium.FormMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    FCaptured := nil;
end;


procedure TfrmCambrium.sbStageMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    FCaptured := nil;
end;

procedure TfrmCambrium.sbStageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
    SX,SY,SPhi, WX,WY,WPhi : Single;
begin
    SPhi := 0;
    SX := X;
    SY := Y;
    Screen2World( SX,SY, SPhi, WX,WY,WPhi );
    FCaptured := FCreatures.FindCreatureAt(WX,WY);
    FPaused := False;
end;

procedure TfrmCambrium.RunSimulation;
var
    I : Integer;
    FPS : Integer;
    GenTime : LongInt;
    AfrmInfo : TfrmInfo;
    CapX,CapY : Single;
    SleepTime : Integer;
begin
    if not FPaused then begin
        repeat

            if FCaptured<>nil then begin
                CapX := FCaptured.XPos;
                CapY := FCaptured.YPos;
            end;
            FCreatures.DoSteps;
            if FCaptured<>nil then begin
                FCaptured.XPos := CapX;
                FCaptured.YPos := CapY;
            end;
            GenTime := (GetTickCount-FLastTick);
            SleepTime := Round(GenTime / (1-(Settings.NiceValue/100)))-GenTime;
            Sleep(SleepTime);
            if GenTime=0 then
                FPS := 2000
            else
                FPS := 1000 div GenTime;
            FLastTick := GetTickCount;
            FFPS := FPS*0.05 + 0.95*FFPS;
            Inc(FTicks);
        until GetTickCount > FLastBlitTime + (1000 div kMaxFrameRate);
    end;

    UpdateScreen;

    for I := 0 to ComponentCount-1 do begin
        if Components[I] is TfrmInfo then begin
            AfrmInfo := Components[I] as TfrmInfo;
            if FCreatures.IndexOf(AfrmInfo.Creature)=-1 then
                AfrmInfo.Release
            else
                AfrmInfo.Update;
        end;
    end;

end;

procedure TfrmCambrium.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    case Key of
       VK_DOWN   : FView.dY := FView.dY + kScrollStep;
       VK_UP     : FView.dY := FView.dY - kScrollStep;
       VK_LEFT   : FView.dX := FView.dX + kScrollStep;
       VK_RIGHT  : FView.dX := FView.dX - kScrollStep;
       ORD('X')  : FView.Phi := FView.Phi + 0.1;
       ORD('Z')  : FView.Phi := FView.Phi - 0.1;
       ORD('Q')  : FView.Size := FView.Size * 0.9;
       ORD('A')  : FView.Size := FView.Size / 0.9;
       ORD('S')  : SaveAnimals;
       ORD(' ')  : FPaused := not FPaused;
       VK_ESCAPE : if WindowState<>wsNormal then WindowState := wsNormal else WindowState := wsMaximized;
    end;
end;

procedure TfrmCambrium.sbStageDblClick(Sender: TObject);
var
    P : TPoint;
    SX,SY,SPhi, WX,WY,WPhi : Single;
    Cre : TCreature;
    InfoWindow : TfrmInfo;
begin
    GetCursorPos( P );
    SX := P.X -Left;
    SY := P.Y - Top;
    SPhi := 0;
    Screen2World( SX,SY, SPhi, WX,WY,WPhi );
    Cre := FCreatures.FindCreatureAt(WX,WY);
    if Cre<>nil then begin
        InfoWindow := TfrmInfo.Create(Self,Cre);
        InfoWindow.Update;
    end;
end;

procedure TfrmCambrium.WMUser( var Msg : TMessage );
begin
    setpriorityclass( GetCurrentProcess ,IDLE_PRIORITY_CLASS);
    repeat
        RunSimulation;
        if (FExitAfter>0) and ((GetTickCount-FStartTick)>FExitAfter) then
            Application.Terminate;
        Application.ProcessMessages;
    until FbQuit;
end;

procedure TfrmCambrium.timerReloadValuesTimer(Sender: TObject);
begin
    Settings.ReloadValues;
end;

procedure TfrmCambrium.UpdateScreen;
var
    I : Integer;
    Logo : TLogoCanvas;
    sX,sY,sPhi : Single;
    YPos : Integer;
    rTotEnergy : Single;
    iFoodCount, iCreatureCount : Integer;
    St, Chunk : String;

    procedure WriteLine(const sFormat: string; const Args: array of const);
    begin
        FbmOffscreen.Canvas.TextOut(0,YPos,Format(sFormat,Args));
        YPos := YPos + 14;
    end;
begin
    FbmOffscreen.Width := ClientWidth;
    FbmOffscreen.Height := ClientHeight;
    iFoodCount := 0;
    iCreatureCount := 0;
    rTotEnergy := 0;
    with FbmOffscreen do begin
        BitBlt( FbmOffscreen.Canvas.Handle,
                0, 0, FbmOffscreen.Width, FbmOffscreen.Height,
                FbmOffscreen.Canvas.Handle, 0,0,
                BLACKNESS );
        Logo := TLogoCanvas.Create( Canvas );
        for I := FCreatures.Count-1 downto 0 do begin
            World2Screen( Creatures[I].XPos, Creatures[I].YPos, Creatures[I].Phi,
                          sX,sY,sPhi );
            if InBetween(Round(sX),0,Width) and InBetween(Round(sY),0,Height) then begin
                Logo.SetPos( sX,sY, sPhi, FView.Size );
                Creatures[I].Draw( Logo );
            end;
            rTotEnergy := rTotEnergy + Creatures[I].Energy;
            if Creatures[I].IsVegetable then
                Inc(iFoodCount)
            else
                Inc(iCreatureCount);
        end;
    end;
    FbmOffscreen.Canvas.Font.Color := clWhite;
    FbmOffscreen.Canvas.Brush.Style := bsClear;

    YPos := 0;
    WriteLine('Generations x1000 : %d',[FTicks div 1000]);
    WriteLine('Steps per sec : %d',[Round(FFPS)]);
    WriteLine('Creatures : %d', [iCreatureCount] );
    WriteLine('Food : %d', [iFoodCount] );
    WriteLine('Biomass : %d', [Round(rTotEnergy) div 100] );
    for I := 0 to FCreatures.Count-1 do begin
        St := Creatures[I].DebugInfo;
        if St<>'' then
             WriteLine('', [] );
        while St<>'' do begin
            Chunk := ExtractTo(St,'\n');
            WriteLine(Chunk, []);
        end;
    end;

    FbmOffscreen.Canvas.TextOut(2,FBmOffscreen.Height-16,
                                'Use Arrow keys to scroll, A/Z to Zoom/Unzoom, X/C to rotate, S to save the current animals as xml');

    FbmOffscreen.Canvas.Font.Color := clBlue;
    FbmOffscreen.Canvas.TextOut(FBmOffscreen.Width-220,FBmOffscreen.Height-16,
                                'http://douweosinga.com/projects/cambrium');

    BitBlt( Canvas.Handle,
            0,0,Width,Height,
            FbmOffscreen.Canvas.Handle,
            0,0,
            SRCCOPY );
    FLastBlitTime := GetTickCount;
end;

procedure TfrmCambrium.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
    FbQuit := True;
end;

procedure TfrmCambrium.butGoClick(Sender: TObject);
var
    slSelected : TStringList;
    I : Integer;
begin
    gbSettings.Visible := False;
    slSelected := TStringList.Create;
    for I := 0 to chklAnimals.Items.Count-1 do
        if chklAnimals.Checked[I] then
            slSelected.Add( chklAnimals.Items[I] );
    FCreatures.Load( Width, Height, slSelected );
    slSelected.Free;
    PostMessage( Handle, WM_USER,0,0 );
end;

var
    FirstShow : Boolean = True;

procedure TfrmCambrium.FormShow(Sender: TObject);
begin
    if not FirstShow then Exit;
    FirstShow := False;
    FindFiles( 'animals\*.cam', faAnyFile, chklAnimals.Items );
end;

procedure TfrmCambrium.SaveAnimals;
begin
    FCreatures.Save( 'animals' );
end;

initialization
{$IFNDEF DEBUG}
    Randomize;
{$ENDIF}
end.
