unit uMutate;

interface
uses
    uDuck,
    Math,
    Graphics,
    WinTypes,
    WinProcs;

function MutateByte( B : Integer; Chance : Real ) : Byte;
function MutateReal( R : Real; Chance : Real ) : Real;
function MutateInteger( I : LongInt; Chance : Real ) : LongInt;
function MutateColor( C : TColor; Chance : Real ) : TColor;
function MutateFactor( F : Real; Chance : Real ) : Real;
function MutateAngle( F : Real; Chance : Real ) : Real;

implementation

function MutateByte( B : Integer; Chance : Real ) : Byte;
begin
    Result := B;
    If Random<Chance then begin
        if Random(2) = 0 then begin
            if B>0 then Result := (B-1)
        end else begin
            if B<255 then Result := (B+1);
        end;
    end else
       Result := B;
end;


function MutateFactor( F : Real; Chance : Real ) : Real;
begin
    if Random<Chance then
        Result := Min(1.0,Max(0.0, F + RandomZ(150)/1000))
    else
        Result := F;
end;

function MutateAngle( F : Real; Chance : Real ) : Real;
begin
    if Random<Chance then begin
       Result := F + RandomZ(30)/1000+RandomZ(30)/1000+RandomZ(30)/1000;
       if Result<0 then Result := Result + 2*Pi;
       if Result>2*Pi then Result := Result - 2*Pi;
    end else
        Result := F;
end;


function MutateReal( R : Real; Chance : Real ) : Real;
begin
    if Random<Chance then 
        R := R * (RandomZ(10)/100 +1);
    Result := R;
end;

function MutateInteger( I : LongInt; Chance : Real ) : LongInt;
begin
    if Random<Chance then
        I := Round(I * (RandomZ(10)/100 +1));
    Result := I;
end;

function MutateColor( C : TColor; Chance : Real ) : TColor;
var
   r,g,b : Integer;
begin
    r := MutateByte(GetRValue(C), Chance);
    g := MutateByte(GetGValue(C), Chance);
    b := MutateByte(GetBValue(C), Chance);
    Result := $02000000 + RGB( r,g,b );
end;


end.
