unit uSettings;

interface

uses
    uDuck, SysUtils, IniFiles;

const
    _kRemming = 0.02;
    _kBrown = 25;
    _kPhiRemming = 0.04;
    _kPhiBrown = 2;
    _kChemicalStabilizer = 0.9;
    _kGravity = 0.0000016;
    _kSunLight : Single = 0.1;
    _kCostOfLiving = 0.25;
    _kMinEnergy = 10;

type
    TSettings = class
      private
        FRemming : Double;
        FBrown : Double;
        FPhiRemming : Double;
        FPhiBrown : Double;
        FChemicalStabilizer : Double;
        FGravity : Double;
        FSunLight : Double;
        FCostOfLiving : Double;
        FMinEnergy : Double;
        FRadiusCost : Double;
        FPartsCost : Double;
        FCreatureCost : Double;

        FMaxFood, FNiceValue : Integer;

        FIniFile : TIniFile;
        function Val(Tag : String ) : Double;
        function iVal(Tag : String ) : Integer;
      public
        constructor Create( IniFileName : String );
        procedure ReloadValues;

        property Remming : Double read FRemming;
        property Brown : Double read FBrown;
        property PhiRemming : Double read FPhiRemming;
        property PhiBrown : Double read FPhiBrown;
        property ChemicalStabilizer : Double read FChemicalStabilizer;
        property Gravity : Double read FGravity;
        property SunLight : Double read FSunLight;
        property CostOfLiving : Double read FCostOfLiving;
        property MinEnergy : Double read FMinEnergy;
        property RadiusCost : Double read FRadiusCost;
        property PartsCost : Double read FPartsCost;
        property CreatureCost : Double read FCreatureCost;
        property MaxFood : Integer read FMaxFood;
        property NiceValue : Integer read FNiceValue;
    end;

var
    Settings : TSettings;

implementation

const
    kProgName = 'CAMBRIUM';

var
    IniF : String;

{ TSettings }

constructor TSettings.Create(IniFileName: String);
begin
    FIniFile := TIniFile.Create( IniFileName );
    ReloadValues;
end;

function TSettings.Val(Tag: String): Double;
begin
    Result := StrToFloat(FIniFile.ReadString( kProgName, Tag, '0.0'));
end;

function TSettings.iVal(Tag : String ) : Integer;
begin
    Result := StrToInt(FIniFile.ReadString(kProgName, Tag, '0'));
end;

procedure TSettings.ReloadValues;
begin
    FRemming := Val('Remming');
    FBrown := Val('Brown');
    FPhiRemming := Val('PhiRemming');
    FPhiBrown := Val('PhiBrown');
    FChemicalStabilizer := Val('ChemicalStabilizer');
    FGravity := Val('Gravity');
    FSunLight := Val('SunLight');
    FCostOfLiving := Val('CostOfLiving');
    FMinEnergy := Val('MinEnergy');
    FRadiusCost := Val('RadiusCost');
    FPartsCost := Val('PartsCost');
    FCreatureCost := Val('CreatureCost');
    FMaxFood := iVal('MaxFood');
    FNiceValue := iVal('NiceValue');
end;

var
    HomeDir : String;

begin
    HomeDir  := ExtractFilePath( ParamStr(0) );
    if HomeDir[Length(HomeDir)]<>'\' then
        HomeDir := HomeDir + '\';
    IniF := HomeDir + kProgName + '.ini';
    Settings := TSettings.Create( IniF );
end.
