unit uAnimal;

interface

uses
    Classes, uProgram, Graphics, uConst;


type
    TAnimal = class
      private
        function GetRegisters(I: Integer): Integer;
        procedure SetRegisters(I: Integer; const Value: Integer);
        procedure SetPC(const Value: Integer);
        function GetColor: Integer;
      public
        FProgram      : TProgram;
        FPC          : Integer;
        FRegisters   : array[0..kMaxRegister-1] of Integer;
        FEnergy      : Integer;
        FXPos, FYPos : Integer;
        FWaitCount   : Integer;
        FdX,FdY      : Integer;
        FDebug       : Integer;
        FMarker      : TColor;
      public
        constructor Create( Script : TStrings; Energy, XP,YP : Integer );
        constructor Clone( FromAnimal : TAnimal );
        destructor Destroy; override;
        procedure ToXY(dLeft,dForward : Integer; var X,Y : Integer );
        property Registers[I : Integer] : Integer read GetRegisters write SetRegisters;
        property PC : Integer read FPC write SetPC;
        property Color : Integer read GetColor;
    end;

    TAnimalList = class(TList)
      private
        function GetItems(I:Integer) : TAnimal;
      public
        function Add( AAnimal : TAnimal ) : TAnimal;
        property Items[ I : Integer ] : TAnimal read GetItems; default;
    end;


implementation
{ TAnimal }

constructor TAnimal.Clone(FromAnimal: TAnimal);
begin
    FProgram := TProgram.Copy( FromAnimal.FProgram );
    FPC := 0;
    FillChar(FRegisters, SizeOf(FRegisters), #0 );
    FEnergy := FromAnimal.FEnergy;
    FXPos := FromAnimal.FXPos;
    FYPos := FromAnimal.FYPos;
    FWaitCount   := 0;
    FdX := FromAnimal.FdX;
    FdY := FromAnimal.FdY;
    FMarker := FromAnimal.FMarker;
end;

constructor TAnimal.Create(Script: TStrings; Energy, XP, YP: Integer);
begin
    FProgram := TProgram.Compile( Script );
    FPC := 0;
    FillChar(FRegisters, SizeOf(FRegisters), #0 );
    FEnergy := Energy;
    FXPos := XP;
    FYPos := YP;
    FWaitCount   := 0;
    FdX := -1;
    FdY := 0;
end;

destructor TAnimal.Destroy;
begin
    FProgram.Free;
    inherited;
end;

function TAnimal.GetColor: Integer;
begin
    GetColor := FProgram.FColor shr 24;
end;

function TAnimal.GetRegisters(I: Integer): Integer;
begin
    Result := 0;
    if (I<0) or (I>=kMaxRegister) then Exit;
    Result := FRegisters[I];
end;

procedure TAnimal.SetPC(const Value: Integer);
begin
    if (Value<-1) or (Value>=FProgram.FSize) then Exit;
    FPC := Value;
end;

procedure TAnimal.SetRegisters(I: Integer; const Value: Integer);
begin
    if (I<0) or (I>=kMaxRegister) then Exit;
    FRegisters[I]:=Value;
end;

function TAnimalList.Add( AAnimal : TAnimal ) : TAnimal;
begin
    inherited Add(AAnimal);
    Result := AAnimal;
end;

function TAnimalList.GetItems(I:Integer) : TAnimal;
begin
    Result := TObject(inherited Items[I]) as TAnimal;
end;

procedure TAnimal.ToXY(dLeft, dForward: Integer; var X, Y: Integer);
begin
    if dLeft<-5 then dLeft:=-5;
    if dLeft>5  then dLeft:=5;
    if dForward<-5 then dForward:=-5;
    if dForward>5 then dForward:=5;
    X := FXPos + FdX*dForward +FdY*dLeft;
    Y := FYPos + FdY*dForward -FdX*dLeft;
    X := (X+kMaxX) mod kMaxX;
    Y := (Y+kMaxY) mod kMaxY;
end;

end.
