unit uConst;

interface

uses
    Classes;

const
    kMaxX       = 240;
    kMaxY       = 160;
    kShowFrameCount = 23;
    kMaxSmells  = 3;
    kMaxEat     = 70;
    kMaxPlant   = 250;
    kDistributeFoodChange = 20;
    kMaxObjects = kMaxX*kMaxY div 300;
    kExtendedPixels = kMaxObjects*2;
    kFoodGrowth = kMaxX*kMaxY div 35;
    kSplitEfficiency = 75;
    kCostOfLiving = 1;
    kInstructionCost = 2; // Minimal energy is lengthprogram * kInstructionCost
    kMinForkPercentage = 3;
    kMaxForkPercentage = 100 - kMinForkPercentage;
    kDeathFromIllnessChance = 4000;

    // normally any instruction takes one turn. These are the exceptions:
    kWait_Fork      = 40;
    kWait_Eat       = 10;
    kWait_HitSucces =  5;
    kWait_Look      =  3;
    kWait_Move      = 10;
    kWait_TestFood  =  3;
    kWait_Turn      =  5;
    kMaxRegister = 256;
    kMutateChange=5;

function  ExtractTo( var Source : String; S : String ) : String;
function TextEqual(S1,S2:String):Boolean;
procedure FindFiles( Path : String; Attr : Integer; Strings : TStrings );

implementation

uses
    SysUtils;

function  ExtractTo( var Source : String; S : String ) : String;
var
    I   : Word;
begin
    I := Pos( S, Source );
    if I = 0 then begin
        ExtractTo := Source;
        Source := '';
        EXIT;
    end;
    ExtractTo := Copy( Source, 1, I-1 );
    Delete( Source, 1, I+Length(S)-1 );
end {ExtractTo};

function TextEqual(S1,S2:String):Boolean;
begin
    Result := UpperCase(S1)=UpperCase(S2);
end;

procedure FindFiles( Path : String; Attr : Integer; Strings : TStrings );
var
    Found : Integer;
    SearchRec : TSearchRec;
begin
    Found := FindFirst(Path, Attr, SearchRec);
    while Found = 0 do begin
        Strings.Add( SearchRec.Name );
        Found := FindNext(SearchRec);
    end;
    FindClose(SearchRec);
end;

end.
